/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.category.ui;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import xaero.common.category.FilterObjectCategory;
import xaero.common.category.rule.ObjectCategoryExcludeList;
import xaero.common.category.rule.ObjectCategoryIncludeList;
import xaero.common.category.rule.ObjectCategoryListRule;
import xaero.common.category.rule.ObjectCategoryListRuleType;
import xaero.common.category.serialization.FilterObjectCategorySerializationHandler;
import xaero.common.category.ui.GuiCategoryUIEditorDataConverter;
import xaero.common.category.ui.data.GuiCategoryUIEditorCategoryData;
import xaero.common.category.ui.data.GuiCategoryUIEditorFilterCategoryData;
import xaero.common.category.ui.data.GuiCategoryUIEditorFilterSettingsData;
import xaero.common.category.ui.data.GuiCategoryUIEditorSimpleDeletableWrapperData;
import xaero.common.category.ui.data.rule.GuiCategoryUIEditorExcludeListData;
import xaero.common.category.ui.data.rule.GuiCategoryUIEditorIncludeListData;

public abstract class GuiFilterCategoryUIEditorDataConverter<E, P, C extends FilterObjectCategory<E, P, ?, C>, ED extends GuiCategoryUIEditorFilterCategoryData<E, P, C, SD, ED>, CB extends FilterObjectCategory.Builder<E, P, C, CB>, SD extends GuiCategoryUIEditorFilterSettingsData<E, P, ?>, SDB extends GuiCategoryUIEditorFilterSettingsData.Builder<E, P, SD, SDB>, EDB extends GuiCategoryUIEditorFilterCategoryData.Builder<E, P, C, ED, SD, SDB, EDB>>
extends GuiCategoryUIEditorDataConverter<C, ED, CB, SD, SDB, EDB> {
    private final ObjectCategoryListRuleType<E, P, ?> defaultListRuleType;
    private final Function<String, ObjectCategoryListRuleType<E, P, ?>> listRuleTypeGetter;
    private final String listRuleTypePrefixSeparator;
    private final Predicate<String> inputRuleTypeStringValidator;

    public GuiFilterCategoryUIEditorDataConverter(@Nonnull Supplier<CB> categoryBuilderFactory, @Nonnull Supplier<EDB> editorDataBuilderFactory, ObjectCategoryListRuleType<E, P, ?> defaultListRuleType, Function<String, ObjectCategoryListRuleType<E, P, ?>> listRuleTypeGetter, String listRuleTypePrefixSeparator, Predicate<String> inputRuleTypeStringValidator) {
        super(categoryBuilderFactory, editorDataBuilderFactory);
        this.defaultListRuleType = defaultListRuleType;
        this.listRuleTypeGetter = listRuleTypeGetter;
        this.listRuleTypePrefixSeparator = listRuleTypePrefixSeparator;
        this.inputRuleTypeStringValidator = inputRuleTypeStringValidator;
    }

    @Override
    protected EDB getConfiguredBuilder(C category, boolean canBeRoot) {
        String prefix;
        GuiCategoryUIEditorFilterCategoryData.Builder editorDataBuilder = (GuiCategoryUIEditorFilterCategoryData.Builder)super.getConfiguredBuilder(category, canBeRoot);
        GuiCategoryUIEditorFilterSettingsData.Builder settingDataBuilder = (GuiCategoryUIEditorFilterSettingsData.Builder)editorDataBuilder.getSettingDataBuilder();
        settingDataBuilder.setBaseRule(((FilterObjectCategory)category).getBaseRule());
        final GuiCategoryUIEditorIncludeListData.Builder includeListBuilder = settingDataBuilder.getIncludeListBuilder();
        final GuiCategoryUIEditorExcludeListData.Builder excludeListBuilder = settingDataBuilder.getExcludeListBuilder();
        for (ObjectCategoryIncludeList objectCategoryIncludeList : ((FilterObjectCategory)category).getIncludeLists()) {
            prefix = objectCategoryIncludeList.getType() == this.defaultListRuleType ? "" : objectCategoryIncludeList.getType().getId() + this.listRuleTypePrefixSeparator;
            objectCategoryIncludeList.forEach(new Consumer<String>(){

                @Override
                public void accept(String el) {
                    includeListBuilder.getList().add((GuiCategoryUIEditorSimpleDeletableWrapperData.Builder<String>)GuiCategoryUIEditorSimpleDeletableWrapperData.Builder.getDefault().setElement(prefix + el));
                }
            });
        }
        for (ObjectCategoryExcludeList objectCategoryExcludeList : ((FilterObjectCategory)category).getExcludeLists()) {
            prefix = objectCategoryExcludeList.getType() == this.defaultListRuleType ? "" : objectCategoryExcludeList.getType().getId() + this.listRuleTypePrefixSeparator;
            objectCategoryExcludeList.forEach(new Consumer<String>(){

                @Override
                public void accept(String el) {
                    excludeListBuilder.getList().add((GuiCategoryUIEditorSimpleDeletableWrapperData.Builder<String>)GuiCategoryUIEditorSimpleDeletableWrapperData.Builder.getDefault().setElement(prefix + el));
                }
            });
        }
        ((GuiCategoryUIEditorFilterCategoryData.Builder)editorDataBuilder.setListRuleTypePrefixSeparator(this.listRuleTypePrefixSeparator)).setInputRuleTypeStringValidator(this.inputRuleTypeStringValidator);
        includeListBuilder.getIncludeInSuperToggleDataBuilder().setCurrentValue(((FilterObjectCategory)category).getIncludeInSuperCategory());
        excludeListBuilder.setExcludeMode(((FilterObjectCategory)category).getExcludeMode());
        return (EDB)editorDataBuilder;
    }

    @Override
    protected CB getConfiguredBuilder(ED editorData) {
        final FilterObjectCategory.Builder categoryBuilder = (FilterObjectCategory.Builder)super.getConfiguredBuilder(editorData);
        GuiCategoryUIEditorFilterSettingsData settingsData = (GuiCategoryUIEditorFilterSettingsData)((GuiCategoryUIEditorCategoryData)editorData).getSettingsData();
        categoryBuilder.setBaseRule(settingsData.getBaseRule());
        categoryBuilder.setIncludeInSuperCategory(settingsData.getIncludeList().getIncludeInSuper());
        categoryBuilder.setExcludeMode(settingsData.getExcludeList().getExcludeMode());
        settingsData.getIncludeList().getList().forEach(new Consumer<GuiCategoryUIEditorSimpleDeletableWrapperData<String>>(){

            @Override
            public void accept(GuiCategoryUIEditorSimpleDeletableWrapperData<String> led) {
                FilterObjectCategorySerializationHandler.handleListRuleSerializedElement((String)led.getElement(), new Function<ObjectCategoryListRuleType<E, P, ?>, ObjectCategoryListRule.Builder<E, P, ?, ?>>(){

                    @Override
                    public ObjectCategoryListRule.Builder<E, P, ?, ?> apply(ObjectCategoryListRuleType<E, P, ?> t) {
                        return categoryBuilder.getIncludeListBuilder(t);
                    }
                }, GuiFilterCategoryUIEditorDataConverter.this.defaultListRuleType, GuiFilterCategoryUIEditorDataConverter.this.listRuleTypeGetter, GuiFilterCategoryUIEditorDataConverter.this.listRuleTypePrefixSeparator);
            }
        });
        settingsData.getExcludeList().getList().forEach(new Consumer<GuiCategoryUIEditorSimpleDeletableWrapperData<String>>(){

            @Override
            public void accept(GuiCategoryUIEditorSimpleDeletableWrapperData<String> led) {
                FilterObjectCategorySerializationHandler.handleListRuleSerializedElement((String)led.getElement(), new Function<ObjectCategoryListRuleType<E, P, ?>, ObjectCategoryListRule.Builder<E, P, ?, ?>>(){

                    @Override
                    public ObjectCategoryListRule.Builder<E, P, ?, ?> apply(ObjectCategoryListRuleType<E, P, ?> t) {
                        return categoryBuilder.getExcludeListBuilder(t);
                    }
                }, GuiFilterCategoryUIEditorDataConverter.this.defaultListRuleType, GuiFilterCategoryUIEditorDataConverter.this.listRuleTypeGetter, GuiFilterCategoryUIEditorDataConverter.this.listRuleTypePrefixSeparator);
            }
        });
        return (CB)categoryBuilder;
    }

    public static abstract class Builder<E, P, C extends FilterObjectCategory<E, P, ?, C>, ED extends GuiCategoryUIEditorFilterCategoryData<E, P, C, SD, ED>, CB extends FilterObjectCategory.Builder<E, P, C, CB>, SD extends GuiCategoryUIEditorFilterSettingsData<E, P, ?>, SDB extends GuiCategoryUIEditorFilterSettingsData.Builder<E, P, SD, SDB>, EDB extends GuiCategoryUIEditorFilterCategoryData.Builder<E, P, C, ED, SD, SDB, EDB>, B extends Builder<E, P, C, ED, CB, SD, SDB, EDB, B>>
    extends GuiCategoryUIEditorDataConverter.Builder<C, ED, CB, SD, SDB, EDB, B> {
        protected ObjectCategoryListRuleType<E, P, ?> defaultListRuleType;
        protected Function<String, ObjectCategoryListRuleType<E, P, ?>> listRuleTypeGetter;
        protected String listRuleTypePrefixSeparator;
        protected Predicate<String> inputRuleTypeStringValidator;

        protected Builder(Supplier<CB> categoryBuilderFactory, Supplier<EDB> editorDataBuilderFactory) {
            super(categoryBuilderFactory, editorDataBuilderFactory);
        }

        @Override
        protected B setDefault() {
            this.setDefaultListRuleType(null);
            this.setListRuleTypeGetter(null);
            this.setListRuleTypePrefixSeparator(";");
            this.setInputRuleTypeStringValidator(new Predicate<String>(){

                @Override
                public boolean test(String s) {
                    return s.matches("[a-z_0-9\\-]+");
                }
            });
            return (B)((Builder)super.setDefault());
        }

        public B setDefaultListRuleType(ObjectCategoryListRuleType<E, P, ?> defaultListRuleType) {
            this.defaultListRuleType = defaultListRuleType;
            return (B)((Builder)this.self);
        }

        public B setListRuleTypeGetter(Function<String, ObjectCategoryListRuleType<E, P, ?>> listRuleTypeGetter) {
            this.listRuleTypeGetter = listRuleTypeGetter;
            return (B)((Builder)this.self);
        }

        public B setListRuleTypePrefixSeparator(String listRuleTypePrefixSeparator) {
            this.listRuleTypePrefixSeparator = listRuleTypePrefixSeparator;
            return (B)((Builder)this.self);
        }

        public B setInputRuleTypeStringValidator(Predicate<String> inputRuleTypeStringValidator) {
            this.inputRuleTypeStringValidator = inputRuleTypeStringValidator;
            return (B)((Builder)this.self);
        }

        @Override
        public GuiCategoryUIEditorDataConverter<C, ED, CB, SD, SDB, EDB> build() {
            if (this.defaultListRuleType == null || this.listRuleTypeGetter == null) {
                throw new IllegalStateException();
            }
            return super.build();
        }

        protected abstract GuiFilterCategoryUIEditorDataConverter<E, P, C, ED, CB, SD, SDB, EDB> buildInternally();
    }
}

