/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.additionallanterns.data;

import com.supermartijn642.additionallanterns.AdditionalLanterns;
import com.supermartijn642.additionallanterns.LanternColor;
import com.supermartijn642.additionallanterns.LanternMaterial;
import com.supermartijn642.core.generator.LanguageGenerator;
import com.supermartijn642.core.generator.ResourceCache;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;

public class LanternLanguageGenerator
extends LanguageGenerator {
    public LanternLanguageGenerator(ResourceCache cache) {
        super("additionallanterns", cache, "en_us");
    }

    public void generate() {
        this.itemGroup((CreativeTabs)AdditionalLanterns.GROUP, "Additional Lanterns");
        for (LanternMaterial material : LanternMaterial.values()) {
            this.block(material.getLanternBlock(), material == LanternMaterial.NORMAL ? "Lantern" : material.englishTranslation + " Lantern");
            if (material.canBeColored) {
                for (LanternColor color : LanternColor.values()) {
                    this.block(material.getLanternBlock(color), material == LanternMaterial.NORMAL ? color.englishTranslation + " Lantern" : color.englishTranslation + " " + material.englishTranslation + " Lantern");
                }
            }
            if (!material.hasChains) continue;
            this.block((Block)material.getChainBlock(), material.englishTranslation.isEmpty() ? "Chain" : material.englishTranslation + " Chain");
        }
    }
}

