/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.additionallanterns;

import com.supermartijn642.additionallanterns.AdditionalLanterns;
import com.supermartijn642.additionallanterns.ChainBlock;
import com.supermartijn642.additionallanterns.LanternBlock;
import com.supermartijn642.additionallanterns.LanternColor;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.core.item.BaseBlockItem;
import com.supermartijn642.core.item.ItemProperties;
import com.supermartijn642.core.registry.RegistrationHandler;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public enum LanternMaterial {
    ANDESITE(true, true, "Andesite", () -> new ItemStack(Blocks.field_150348_b, 1, 5), null, 4, () -> new ItemStack(Blocks.field_150348_b, 1, 5), () -> new ItemStack(Blocks.field_150348_b, 1, 5), 8),
    BONE(true, true, "Bone", () -> new ItemStack(Items.field_151103_aS), () -> new ItemStack(Items.field_151103_aS), 1, () -> new ItemStack(Blocks.field_189880_di), () -> new ItemStack(Items.field_151103_aS), 3),
    BRICKS(true, true, "Brick", () -> new ItemStack(Items.field_151118_aC), null, 1, () -> new ItemStack(Blocks.field_150336_V), () -> new ItemStack(Items.field_151118_aC), 4),
    COBBLESTONE(true, true, "Cobblestone", () -> new ItemStack(Blocks.field_150347_e), null, 4, () -> new ItemStack(Blocks.field_150347_e), () -> new ItemStack(Blocks.field_150347_e), 8),
    DARK_PRISMARINE(true, true, "Dark Prismarine", () -> new ItemStack(Blocks.field_180397_cI, 1, 2), null, 4, () -> new ItemStack(Blocks.field_180397_cI, 1, 2), () -> new ItemStack(Blocks.field_180397_cI, 1, 2), 4),
    DIAMOND(true, true, "Diamond", () -> new ItemStack(Items.field_151045_i), null, 1, () -> new ItemStack(Items.field_151045_i), () -> new ItemStack(Items.field_151045_i), 3),
    DIORITE(true, true, "Diorite", () -> new ItemStack(Blocks.field_150348_b, 1, 3), null, 4, () -> new ItemStack(Blocks.field_150348_b, 1, 3), () -> new ItemStack(Blocks.field_150348_b, 1, 3), 8),
    EMERALD(true, true, "Emerald", () -> new ItemStack(Items.field_151166_bC), null, 1, () -> new ItemStack(Items.field_151166_bC), () -> new ItemStack(Items.field_151166_bC), 3),
    END_STONE(true, true, "End Stone", () -> new ItemStack(Blocks.field_150377_bs), null, 4, () -> new ItemStack(Blocks.field_150377_bs), () -> new ItemStack(Blocks.field_150377_bs), 8),
    GOLD(true, true, "Gold", () -> new ItemStack(Items.field_151074_bl), () -> new ItemStack(Items.field_151074_bl), 1, () -> new ItemStack(Items.field_151043_k), () -> new ItemStack(Items.field_151074_bl), 1),
    GRANITE(true, true, "Granite", () -> new ItemStack(Blocks.field_150348_b, 1, 1), null, 4, () -> new ItemStack(Blocks.field_150348_b, 1, 1), () -> new ItemStack(Blocks.field_150348_b, 1, 1), 8),
    IRON(true, false, "Iron", () -> new ItemStack(Items.field_151042_j), null, 1, null, null, 0),
    MOSSY_COBBLESTONE(true, true, "Mossy Cobblestone", () -> new ItemStack(Blocks.field_150341_Y), null, 4, () -> new ItemStack(Blocks.field_150341_Y), () -> new ItemStack(Blocks.field_150347_e), 8),
    NORMAL(true, true, "", () -> new ItemStack(Items.field_191525_da), () -> new ItemStack(Items.field_191525_da), 1, () -> new ItemStack(Items.field_151042_j), () -> new ItemStack(Items.field_191525_da), 1),
    NORMAL_NETHER_BRICKS(true, true, "Nether Brick", () -> new ItemStack(Items.field_151130_bT), null, 1, () -> new ItemStack(Blocks.field_150385_bj), () -> new ItemStack(Items.field_151130_bT), 4),
    NORMAL_SANDSTONE(true, true, "Sandstone", () -> new ItemStack(Blocks.field_150322_A), null, 4, () -> new ItemStack(Blocks.field_150322_A), () -> new ItemStack(Blocks.field_150322_A), 8),
    OBSIDIAN(true, true, "Obsidian", () -> new ItemStack(Blocks.field_150343_Z), null, 4, () -> new ItemStack(Blocks.field_150343_Z), () -> new ItemStack(Blocks.field_150343_Z), 8),
    PRISMARINE(true, true, "Prismarine", () -> new ItemStack(Items.field_179562_cC), null, 1, () -> new ItemStack(Blocks.field_180397_cI, 1, 1), () -> new ItemStack(Items.field_179562_cC), 4),
    PURPUR(true, true, "Purpur", () -> new ItemStack(Items.field_185162_cT), null, 1, () -> new ItemStack(Blocks.field_185767_cT), () -> new ItemStack(Items.field_185162_cT), 4),
    QUARTZ(true, true, "Quartz", () -> new ItemStack(Items.field_151128_bU), () -> new ItemStack(Items.field_151128_bU), 1, () -> new ItemStack(Blocks.field_150371_ca), () -> new ItemStack(Items.field_151128_bU), 4),
    RED_NETHER_BRICKS(true, true, "Red Nether Brick", () -> new ItemStack(Blocks.field_189879_dh), null, 4, () -> new ItemStack(Blocks.field_189879_dh), () -> new ItemStack(Items.field_151130_bT), 8),
    RED_SANDSTONE(true, true, "Red Sandstone", () -> new ItemStack(Blocks.field_180395_cM), null, 4, () -> new ItemStack(Blocks.field_180395_cM), () -> new ItemStack(Blocks.field_180395_cM), 8),
    SMOOTH_STONE(true, true, "Smooth Stone", () -> new ItemStack(Blocks.field_150348_b), null, 4, () -> new ItemStack(Blocks.field_150348_b), () -> new ItemStack(Blocks.field_150348_b), 8),
    STONE(true, true, "Stone", () -> new ItemStack(Blocks.field_150348_b, 1, 0), null, 4, () -> new ItemStack(Blocks.field_150348_b, 1, 0), () -> new ItemStack(Blocks.field_150348_b, 1, 0), 8),
    STONE_BRICKS(true, true, "Stone Bricks", () -> new ItemStack(Blocks.field_150417_aV, 1, 0), null, 4, () -> new ItemStack(Blocks.field_150417_aV, 1, 0), () -> new ItemStack(Blocks.field_150417_aV, 1, 0), 8);

    public final boolean canBeColored;
    public final boolean hasChains;
    private LanternBlock lanternBlock;
    private final Map<LanternColor, LanternBlock> coloredLanternBlocks = new EnumMap<LanternColor, LanternBlock>(LanternColor.class);
    private ChainBlock chainBlock;
    private Item lanternItem;
    private final Map<LanternColor, Item> coloredLanternItems = new EnumMap<LanternColor, Item>(LanternColor.class);
    private Item chainItem;
    public final String englishTranslation;
    public final Supplier<ItemStack> primaryLanternIngredient;
    public final Supplier<ItemStack> secondaryLanternIngredient;
    public final int lanternRecipeCount;
    public final Supplier<ItemStack> primaryChainIngredient;
    public final Supplier<ItemStack> secondaryChainIngredient;
    public final int chainRecipeCount;

    private LanternMaterial(boolean canBeColored, boolean hasChains, String englishTranslation, Supplier<ItemStack> primaryLanternIngredient, Supplier<ItemStack> secondaryLanternIngredient, int lanternRecipeCount, Supplier<ItemStack> primaryChainIngredient, Supplier<ItemStack> secondaryChainIngredient, int chainRecipeCount) {
        this.canBeColored = canBeColored;
        this.hasChains = hasChains;
        this.englishTranslation = englishTranslation;
        this.primaryLanternIngredient = primaryLanternIngredient;
        this.secondaryLanternIngredient = secondaryLanternIngredient;
        this.lanternRecipeCount = lanternRecipeCount;
        this.primaryChainIngredient = primaryChainIngredient;
        this.secondaryChainIngredient = secondaryChainIngredient;
        this.chainRecipeCount = chainRecipeCount;
    }

    public Block getLanternBlock() {
        return this.lanternBlock;
    }

    public Block getLanternBlock(LanternColor color) {
        if (color == null) {
            return this.getLanternBlock();
        }
        return (Block)this.coloredLanternBlocks.get((Object)color);
    }

    public ChainBlock getChainBlock() {
        return this.chainBlock;
    }

    public String getSuffix() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    private String getLanternIdentifier(LanternColor color) {
        if (color == null) {
            return this.getSuffix() + "_lantern";
        }
        return color.getSuffix() + "_" + this.getSuffix() + "_lantern";
    }

    private String getChainIdentifier() {
        return this.getSuffix() + "_chain";
    }

    public BlockProperties getLanternBlockProperties() {
        return BlockProperties.create((Material)Material.field_151573_f).requiresCorrectTool().destroyTime(5.0f).explosionResistance(6.0f).sound(SoundType.field_185852_e).lightLevel(state -> LanternBlock.emitsLight(state) ? 15 : 0);
    }

    public void registerBlocks(RegistrationHandler.Helper<Block> helper) {
        if (this.lanternBlock != null) {
            throw new IllegalStateException("Blocks have already been registered!");
        }
        this.lanternBlock = new LanternBlock(this, null);
        helper.register(this.getLanternIdentifier(null), (Object)this.lanternBlock);
        if (this.canBeColored) {
            for (LanternColor color : LanternColor.values()) {
                LanternBlock block = new LanternBlock(this, color);
                this.coloredLanternBlocks.put(color, block);
                helper.register(this.getLanternIdentifier(color), (Object)block);
            }
        }
        if (this.hasChains) {
            this.chainBlock = new ChainBlock(this);
            helper.register(this.getChainIdentifier(), (Object)this.chainBlock);
        }
    }

    public void registerItems(RegistrationHandler.Helper<Item> helper) {
        if (this.lanternItem != null) {
            throw new IllegalStateException("Items have already been registered!");
        }
        if (this.lanternBlock == null) {
            throw new IllegalStateException("Blocks must be registered before registering items!");
        }
        this.lanternItem = new BaseBlockItem((Block)this.lanternBlock, ItemProperties.create().group((CreativeTabs)AdditionalLanterns.GROUP));
        helper.register(this.getLanternIdentifier(null), (Object)this.lanternItem);
        OreDictionary.registerOre((String)(this.getSuffix() + "_lanterns"), (Item)this.lanternItem);
        if (this.canBeColored) {
            for (LanternColor color : LanternColor.values()) {
                LanternBlock block = this.coloredLanternBlocks.get((Object)color);
                BaseBlockItem item = new BaseBlockItem((Block)block, ItemProperties.create().group((CreativeTabs)AdditionalLanterns.GROUP));
                this.coloredLanternItems.put(color, (Item)item);
                helper.register(this.getLanternIdentifier(color), (Object)item);
                OreDictionary.registerOre((String)(this.getSuffix() + "_lanterns"), (Item)item);
            }
        }
        if (this.hasChains) {
            this.chainItem = new BaseBlockItem((Block)this.chainBlock, ItemProperties.create().group((CreativeTabs)AdditionalLanterns.GROUP));
            helper.register(this.getChainIdentifier(), (Object)this.chainItem);
        }
    }
}

