/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.additionallanterns;

import com.supermartijn642.additionallanterns.AdditionalLanternsClient;
import com.supermartijn642.additionallanterns.LanternColor;
import com.supermartijn642.additionallanterns.LanternMaterial;
import com.supermartijn642.additionallanterns.data.LanternBlockModelGenerator;
import com.supermartijn642.additionallanterns.data.LanternBlockStateGenerator;
import com.supermartijn642.additionallanterns.data.LanternItemModelGenerator;
import com.supermartijn642.additionallanterns.data.LanternLanguageGenerator;
import com.supermartijn642.additionallanterns.data.LanternLootTableGenerator;
import com.supermartijn642.additionallanterns.data.LanternRecipeGenerator;
import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.item.CreativeItemGroup;
import com.supermartijn642.core.registry.GeneratorRegistrationHandler;
import com.supermartijn642.core.registry.RegistrationHandler;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.Logger;

@Mod(modid="additionallanterns", name="Additional Lanterns", version="1.1.2", dependencies="required-after:forge@[14.23.5.2779,);required-after:supermartijn642corelib@[1.1.17,1.2.0)")
public class AdditionalLanterns {
    public static final CreativeItemGroup GROUP = CreativeItemGroup.create((String)"additionallanterns", AdditionalLanterns::randomLantern).filler(items -> {
        for (LanternMaterial material : LanternMaterial.values()) {
            items.accept(new ItemStack(material.getLanternBlock()));
            for (LanternColor color : LanternColor.values()) {
                items.accept(new ItemStack(material.getLanternBlock(color)));
            }
            if (!material.hasChains) continue;
            items.accept(new ItemStack((Block)material.getChainBlock()));
        }
    });
    public static final Logger LOGGER = CommonUtils.getLogger((String)"additionallanterns");
    private static final Random RANDOM = new Random();

    private static Block randomLantern() {
        LanternMaterial material = LanternMaterial.values()[RANDOM.nextInt(LanternMaterial.values().length)];
        int colorIndex = RANDOM.nextInt(LanternColor.values().length + 1);
        LanternColor color = colorIndex < LanternColor.values().length ? LanternColor.values()[colorIndex] : null;
        return material.getLanternBlock(color);
    }

    public AdditionalLanterns() {
        AdditionalLanterns.register();
        if (CommonUtils.getEnvironmentSide().isClient()) {
            AdditionalLanternsClient.register();
        }
        AdditionalLanterns.registerGenerators();
    }

    private static void register() {
        RegistrationHandler handler = RegistrationHandler.get((String)"additionallanterns");
        for (LanternMaterial material : LanternMaterial.values()) {
            handler.registerBlockCallback(material::registerBlocks);
            handler.registerItemCallback(material::registerItems);
        }
    }

    private static void registerGenerators() {
        GeneratorRegistrationHandler handler = GeneratorRegistrationHandler.get((String)"additionallanterns");
        handler.addGenerator(LanternBlockModelGenerator::new);
        handler.addGenerator(LanternItemModelGenerator::new);
        handler.addGenerator(LanternBlockStateGenerator::new);
        handler.addGenerator(LanternLanguageGenerator::new);
        handler.addGenerator(LanternLootTableGenerator::new);
        handler.addGenerator(LanternRecipeGenerator::new);
    }
}

