/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client.microphone;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.voice.client.MicrophoneException;
import de.maxhenkel.voicechat.voice.client.SoundManager;
import de.maxhenkel.voicechat.voice.client.microphone.Microphone;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALC11;
import org.lwjgl.openal.ALCdevice;

public class ALMicrophone
implements Microphone {
    private final int sampleRate;
    @Nullable
    private final String deviceName;
    private ALCdevice device;
    private final int bufferSize;
    private boolean started;
    private final ByteBuffer buffer;

    public ALMicrophone(int sampleRate, int bufferSize, @Nullable String deviceName) {
        this.sampleRate = sampleRate;
        this.deviceName = deviceName;
        this.bufferSize = bufferSize;
        this.buffer = BufferUtils.createByteBuffer((int)(bufferSize * 2));
    }

    @Override
    public void open() throws MicrophoneException {
        if (this.isOpen()) {
            throw new MicrophoneException("Microphone already open");
        }
        this.device = this.openMic(this.deviceName);
    }

    @Override
    public void start() {
        if (!this.isOpen()) {
            return;
        }
        if (this.started) {
            return;
        }
        ALC11.alcCaptureStart((ALCdevice)this.device);
        SoundManager.checkAlcError(this.device);
        this.started = true;
    }

    @Override
    public void stop() {
        if (!this.isOpen()) {
            return;
        }
        if (!this.started) {
            return;
        }
        ALC11.alcCaptureStop((ALCdevice)this.device);
        SoundManager.checkAlcError(this.device);
        this.started = false;
        int available = this.available();
        this.buffer.reset();
        ALC11.alcCaptureSamples((ALCdevice)this.device, (ByteBuffer)this.buffer, (int)available);
        SoundManager.checkAlcError(this.device);
        Voicechat.LOGGER.debug("Clearing {} samples", (Object)available);
    }

    @Override
    public void close() {
        if (!this.isOpen()) {
            return;
        }
        this.stop();
        ALC11.alcCaptureCloseDevice((ALCdevice)this.device);
        SoundManager.checkAlcError(this.device);
        this.device = null;
    }

    @Override
    public boolean isOpen() {
        return this.device != null;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public int available() {
        IntBuffer buffer = BufferUtils.createIntBuffer((int)1);
        ALC10.alcGetInteger((ALCdevice)this.device, (int)786, (IntBuffer)buffer);
        SoundManager.checkAlcError(this.device);
        return buffer.get();
    }

    @Override
    public short[] read() {
        int available = this.available();
        if (this.bufferSize > available) {
            throw new IllegalStateException(String.format("Failed to read from microphone: Capacity %s, available %s", this.bufferSize, available));
        }
        short[] buff = new short[this.bufferSize];
        this.buffer.clear();
        ALC11.alcCaptureSamples((ALCdevice)this.device, (ByteBuffer)this.buffer, (int)buff.length);
        SoundManager.checkAlcError(this.device);
        this.buffer.rewind();
        this.buffer.asShortBuffer().get(buff);
        return buff;
    }

    private ALCdevice openMic(@Nullable String name) throws MicrophoneException {
        try {
            return this.tryOpenMic(name);
        }
        catch (MicrophoneException e) {
            if (name != null) {
                Voicechat.LOGGER.warn("Failed to open microphone '{}', falling back to default microphone", (Object)name);
            }
            try {
                return this.tryOpenMic(ALMicrophone.getDefaultMicrophone());
            }
            catch (MicrophoneException ex) {
                return this.tryOpenMic(null);
            }
        }
    }

    private ALCdevice tryOpenMic(@Nullable String string) throws MicrophoneException {
        ALCdevice l = ALC11.alcCaptureOpenDevice((String)string, (int)this.sampleRate, (int)4353, (int)this.bufferSize);
        if (l == null) {
            SoundManager.checkAlcError(null);
            throw new MicrophoneException(String.format("Failed to open microphone: %s", SoundManager.getAlcError(0)));
        }
        SoundManager.checkAlcError(l);
        return l;
    }

    @Nullable
    public static String getDefaultMicrophone() {
        if (!SoundManager.canEnumerate()) {
            return null;
        }
        String mic = ALC10.alcGetString(null, (int)784);
        SoundManager.checkAlcError(null);
        return mic;
    }

    public static List<String> getAllMicrophones() {
        if (!SoundManager.canEnumerate()) {
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }
}

