/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.net;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.net.AddCategoryPacket;
import de.maxhenkel.voicechat.net.AddGroupPacket;
import de.maxhenkel.voicechat.net.Channel;
import de.maxhenkel.voicechat.net.CreateGroupPacket;
import de.maxhenkel.voicechat.net.JoinGroupPacket;
import de.maxhenkel.voicechat.net.JoinedGroupPacket;
import de.maxhenkel.voicechat.net.LeaveGroupPacket;
import de.maxhenkel.voicechat.net.Packet;
import de.maxhenkel.voicechat.net.PlayerStatePacket;
import de.maxhenkel.voicechat.net.PlayerStatesPacket;
import de.maxhenkel.voicechat.net.RemoveCategoryPacket;
import de.maxhenkel.voicechat.net.RemoveGroupPacket;
import de.maxhenkel.voicechat.net.RequestSecretPacket;
import de.maxhenkel.voicechat.net.SecretPacket;
import de.maxhenkel.voicechat.net.UpdateStatePacket;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.network.play.server.SPacketCustomPayload;
import net.minecraft.server.MinecraftServer;

public abstract class NetManager {
    public static final String CHANNEL = "vc";
    public Channel<UpdateStatePacket> updateStateChannel;
    public Channel<PlayerStatePacket> playerStateChannel;
    public Channel<PlayerStatesPacket> playerStatesChannel;
    public Channel<SecretPacket> secretChannel;
    public Channel<RequestSecretPacket> requestSecretChannel;
    public Channel<AddGroupPacket> addGroupChannel;
    public Channel<RemoveGroupPacket> removeGroupChannel;
    public Channel<JoinGroupPacket> joinGroupChannel;
    public Channel<CreateGroupPacket> createGroupChannel;
    public Channel<LeaveGroupPacket> leaveGroupChannel;
    public Channel<JoinedGroupPacket> joinedGroupChannel;
    public Channel<AddCategoryPacket> addCategoryChannel;
    public Channel<RemoveCategoryPacket> removeCategoryChannel;

    public void init() {
        this.updateStateChannel = this.registerReceiver(UpdateStatePacket.class, false, true);
        this.playerStateChannel = this.registerReceiver(PlayerStatePacket.class, true, false);
        this.playerStatesChannel = this.registerReceiver(PlayerStatesPacket.class, true, false);
        this.secretChannel = this.registerReceiver(SecretPacket.class, true, false);
        this.requestSecretChannel = this.registerReceiver(RequestSecretPacket.class, false, true);
        this.addGroupChannel = this.registerReceiver(AddGroupPacket.class, true, false);
        this.removeGroupChannel = this.registerReceiver(RemoveGroupPacket.class, true, false);
        this.joinGroupChannel = this.registerReceiver(JoinGroupPacket.class, false, true);
        this.createGroupChannel = this.registerReceiver(CreateGroupPacket.class, false, true);
        this.leaveGroupChannel = this.registerReceiver(LeaveGroupPacket.class, false, true);
        this.joinedGroupChannel = this.registerReceiver(JoinedGroupPacket.class, true, false);
        this.addCategoryChannel = this.registerReceiver(AddCategoryPacket.class, true, false);
        this.removeCategoryChannel = this.registerReceiver(RemoveCategoryPacket.class, true, false);
    }

    public abstract <T extends Packet<T>> Channel<T> registerReceiver(Class<T> var1, boolean var2, boolean var3);

    public static void sendToServer(Packet<?> packet) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        packet.toBytes(buffer);
        NetHandlerPlayClient connection = Minecraft.func_71410_x().func_147114_u();
        if (connection != null) {
            connection.func_147297_a((net.minecraft.network.Packet)new CPacketCustomPayload(packet.getIdentifier().toString(), buffer));
        }
    }

    public static void sendToClient(EntityPlayerMP player, Packet<?> packet) {
        if (!Voicechat.SERVER.isCompatible(player)) {
            return;
        }
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        packet.toBytes(buffer);
        player.field_71135_a.func_147359_a((net.minecraft.network.Packet)new SPacketCustomPayload(packet.getIdentifier().toString(), buffer));
    }

    public static interface ClientReceiver<T extends Packet<T>> {
        public void onPacket(Minecraft var1, NetHandlerPlayClient var2, T var3);
    }

    public static interface ServerReceiver<T extends Packet<T>> {
        public void onPacket(MinecraftServer var1, EntityPlayerMP var2, NetHandlerPlayServer var3, T var4);
    }
}

