/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.utils.FileUtils;
import com.gitlab.cdagaming.craftpresence.core.utils.StringUtils;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class NbtUtils {
    public static NBTTagCompound getNbt(Entity entity) {
        NBTTagCompound result = new NBTTagCompound();
        return entity != null ? entity.func_189511_e(result) : result;
    }

    public static NBTTagCompound getNbt(ItemStack stack) {
        NBTTagCompound result = new NBTTagCompound();
        return stack != null ? stack.func_77955_b(result) : result;
    }

    public static NBTBase getNbt(Object data, String ... path) {
        if (data instanceof Entity) {
            return NbtUtils.getNbt((Entity)data, path);
        }
        if (data instanceof ItemStack) {
            return NbtUtils.getNbt((ItemStack)data, path);
        }
        return null;
    }

    public static NBTBase getNbt(Entity entity, String ... path) {
        return NbtUtils.getNbt(NbtUtils.getNbt(entity), path);
    }

    public static NBTBase getNbt(ItemStack stack, String ... path) {
        return NbtUtils.getNbt(NbtUtils.getNbt(stack), path);
    }

    public static NBTBase getNbt(NBTTagCompound root, String ... path) {
        if (path == null || path.length == 0) {
            return root;
        }
        NBTTagCompound currentTag = root;
        for (int i = 0; i < path.length; ++i) {
            if (currentTag instanceof NBTTagCompound) {
                currentTag = currentTag.func_74781_a(path[i]);
                continue;
            }
            if (currentTag instanceof NBTTagList) {
                int index = Integer.parseInt(path[i]);
                currentTag = ((NBTTagList)currentTag).func_179238_g(index);
                continue;
            }
            if (i == path.length - 1) break;
            return null;
        }
        return currentTag;
    }

    public static Object parseTag(NBTBase tag) {
        if (tag == null) {
            return null;
        }
        switch (tag.func_74732_a()) {
            case 1: {
                return ((NBTTagByte)tag).func_150290_f();
            }
            case 2: {
                return ((NBTTagShort)tag).func_150289_e();
            }
            case 3: {
                return ((NBTTagInt)tag).func_150287_d();
            }
            case 4: {
                return ((NBTTagLong)tag).func_150291_c();
            }
            case 5: {
                return Float.valueOf(((NBTTagFloat)tag).func_150288_h());
            }
            case 6: {
                return ((NBTTagDouble)tag).func_150286_g();
            }
            case 7: {
                return ((NBTTagByteArray)tag).func_150292_c();
            }
            case 8: {
                return ((NBTTagString)tag).func_150285_a_();
            }
            case 9: {
                NBTTagList list = (NBTTagList)tag;
                List converted = StringUtils.newArrayList();
                if (!list.func_82582_d()) {
                    for (int i = 0; i < list.func_74745_c(); ++i) {
                        converted.add(NbtUtils.parseTag(list.func_179238_g(i)));
                    }
                }
                return converted;
            }
            case 10: {
                try {
                    return FileUtils.toJsonData(tag.toString(), new FileUtils.Modifiers[0]);
                }
                catch (Throwable ex) {
                    Constants.LOG.debugError(ex);
                    return tag.toString();
                }
            }
            case 11: {
                return ((NBTTagIntArray)tag).func_150302_c();
            }
        }
        return tag;
    }
}

