/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.config.gui;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.element.ColorData;
import com.gitlab.cdagaming.craftpresence.core.config.element.ColorSection;
import com.gitlab.cdagaming.craftpresence.core.impl.Pair;
import com.gitlab.cdagaming.craftpresence.core.impl.Tuple;
import com.gitlab.cdagaming.craftpresence.core.utils.StringUtils;
import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.SliderControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.impl.ConfigurationGui;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.TextDisplayWidget;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.TextWidget;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.TexturedWidget;
import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.class_388;

public class ColorEditorGui
extends ConfigurationGui<ColorData> {
    private final ColorData DEFAULTS;
    private final ColorData INSTANCE;
    private final ColorData CURRENT;
    private final ColorData storedStart;
    private final ColorData storedEnd;
    private final Supplier<ColorData> syncSupplier;
    private SliderControl startRed;
    private SliderControl startGreen;
    private SliderControl startBlue;
    private SliderControl startAlpha;
    private SliderControl endRed;
    private SliderControl endGreen;
    private SliderControl endBlue;
    private SliderControl endAlpha;
    private TextWidget textureLocationText;
    private TextWidget startColorText;
    private TextWidget endColorText;
    private SliderControl tintFactor;

    ColorEditorGui(class_388 parentScreen, ColorData moduleData, ColorData defaultData, Supplier<ColorData> syncData) {
        super(parentScreen, "gui.config.title", "gui.config.title.editor.color");
        this.DEFAULTS = defaultData;
        this.INSTANCE = moduleData.copy();
        this.CURRENT = moduleData;
        this.syncSupplier = syncData;
        this.storedStart = new ColorData(this.getInstance().getStart());
        this.storedEnd = new ColorData(this.getInstance().getEnd());
    }

    @Override
    protected void appendControls() {
        super.appendControls();
        int calc1 = this.getScreenWidth() / 2 - 183;
        int calc2 = this.getScreenWidth() / 2 + 3;
        int calcAlt = calc2 + 180;
        String startColorTitle = Constants.TRANSLATOR.translate("gui.config.message.editor.color.start", new Object[0]);
        String endColorTitle = Constants.TRANSLATOR.translate("gui.config.message.editor.color.end", new Object[0]);
        String previewTitle = Constants.TRANSLATOR.translate("gui.config.message.editor.color.preview", new Object[0]);
        String redTitle = Constants.TRANSLATOR.translate("gui.config.message.editor.color.value.red", new Object[0]);
        String greenTitle = Constants.TRANSLATOR.translate("gui.config.message.editor.color.value.green", new Object[0]);
        String blueTitle = Constants.TRANSLATOR.translate("gui.config.message.editor.color.value.blue", new Object[0]);
        String alphaTitle = Constants.TRANSLATOR.translate("gui.config.message.editor.color.value.alpha", new Object[0]);
        String tintFactorTitle = Constants.TRANSLATOR.translate("gui.config.message.editor.color.tint_factor", new Object[0]);
        this.childFrame.addWidget(new TextDisplayWidget((ExtendedScreen)this.childFrame, calc1, this.getButtonY(0), this.getScreenWidth(), startColorTitle));
        this.startColorText = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(1), 180, 20, () -> {
            String newText = this.startColorText.getControlMessage();
            if (StringUtils.isValidColorCode(newText)) {
                Color newColor = StringUtils.findColor(newText);
                this.startRed.setSliderValue(newColor.getRed());
                this.startGreen.setSliderValue(newColor.getGreen());
                this.startBlue.setSliderValue(newColor.getBlue());
                this.startAlpha.setSliderValue(newColor.getAlpha());
            }
        }, "gui.config.message.editor.hex_code"));
        this.startRed = this.childFrame.addControl(new SliderControl(new Pair<Integer, Integer>(calc1, this.getButtonY(2)), new Pair<Integer, Integer>(180, 20), (float)this.getInstance().getStart().red, 0.0f, 255.0f, 1.0f, redTitle, new Tuple<Runnable, Object, Runnable>(() -> {
            ColorSection sect = this.getInstance().getStart();
            sect.red = (int)this.startRed.getSliderValue();
            this.setStartColor(sect);
        }, null, () -> {
            ColorSection sect = this.getInstance().getStart();
            sect.red = (int)this.startRed.getSliderValue();
            this.setStartColor(sect);
        })));
        this.startGreen = this.childFrame.addControl(new SliderControl(new Pair<Integer, Integer>(calc1, this.getButtonY(3)), new Pair<Integer, Integer>(180, 20), (float)this.getInstance().getStart().green, 0.0f, 255.0f, 1.0f, greenTitle, new Tuple<Runnable, Object, Runnable>(() -> {
            ColorSection sect = this.getInstance().getStart();
            sect.green = (int)this.startGreen.getSliderValue();
            this.setStartColor(sect);
        }, null, () -> {
            ColorSection sect = this.getInstance().getStart();
            sect.green = (int)this.startGreen.getSliderValue();
            this.setStartColor(sect);
        })));
        this.startBlue = this.childFrame.addControl(new SliderControl(new Pair<Integer, Integer>(calc1, this.getButtonY(4)), new Pair<Integer, Integer>(180, 20), (float)this.getInstance().getStart().blue, 0.0f, 255.0f, 1.0f, blueTitle, new Tuple<Runnable, Object, Runnable>(() -> {
            ColorSection sect = this.getInstance().getStart();
            sect.blue = (int)this.startBlue.getSliderValue();
            this.setStartColor(sect);
        }, null, () -> {
            ColorSection sect = this.getInstance().getStart();
            sect.blue = (int)this.startBlue.getSliderValue();
            this.setStartColor(sect);
        })));
        this.startAlpha = this.childFrame.addControl(new SliderControl(new Pair<Integer, Integer>(calc1, this.getButtonY(5)), new Pair<Integer, Integer>(180, 20), (float)this.getInstance().getStart().alpha, 0.0f, 255.0f, 1.0f, alphaTitle, new Tuple<Runnable, Object, Runnable>(() -> {
            ColorSection sect = this.getInstance().getStart();
            sect.alpha = (int)this.startAlpha.getSliderValue();
            this.setStartColor(sect);
        }, null, () -> {
            ColorSection sect = this.getInstance().getStart();
            sect.alpha = (int)this.startAlpha.getSliderValue();
            this.setStartColor(sect);
        })));
        this.childFrame.addWidget(new TexturedWidget(this.childFrame, calc2, this.getButtonY(2, 1), calcAlt, 93, 0.0, () -> Float.valueOf(1.0f), () -> this.storedStart, true));
        this.childFrame.addWidget(new TextDisplayWidget((ExtendedScreen)this.childFrame, calc1, this.getButtonY(6), this.getScreenWidth(), endColorTitle));
        this.endColorText = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(7), 180, 20, () -> {
            String newText = this.endColorText.getControlMessage();
            if (StringUtils.isValidColorCode(newText)) {
                Color newColor = StringUtils.findColor(newText);
                this.endRed.setSliderValue(newColor.getRed());
                this.endGreen.setSliderValue(newColor.getGreen());
                this.endBlue.setSliderValue(newColor.getBlue());
                this.endAlpha.setSliderValue(newColor.getAlpha());
            }
        }, "gui.config.message.editor.hex_code"));
        this.endRed = this.childFrame.addControl(new SliderControl(new Pair<Integer, Integer>(calc1, this.getButtonY(8)), new Pair<Integer, Integer>(180, 20), (float)this.getInstance().getEnd().red, 0.0f, 255.0f, 1.0f, redTitle, new Tuple<Runnable, Object, Runnable>(() -> {
            ColorSection sect = this.getInstance().getEnd();
            sect.red = (int)this.endRed.getSliderValue();
            this.setEndColor(sect);
        }, null, () -> {
            ColorSection sect = this.getInstance().getEnd();
            sect.red = (int)this.endRed.getSliderValue();
            this.setEndColor(sect);
        })));
        this.endGreen = this.childFrame.addControl(new SliderControl(new Pair<Integer, Integer>(calc1, this.getButtonY(9)), new Pair<Integer, Integer>(180, 20), (float)this.getInstance().getEnd().green, 0.0f, 255.0f, 1.0f, greenTitle, new Tuple<Runnable, Object, Runnable>(() -> {
            ColorSection sect = this.getInstance().getEnd();
            sect.green = (int)this.endGreen.getSliderValue();
            this.setEndColor(sect);
        }, null, () -> {
            ColorSection sect = this.getInstance().getEnd();
            sect.green = (int)this.endGreen.getSliderValue();
            this.setEndColor(sect);
        })));
        this.endBlue = this.childFrame.addControl(new SliderControl(new Pair<Integer, Integer>(calc1, this.getButtonY(10)), new Pair<Integer, Integer>(180, 20), (float)this.getInstance().getEnd().blue, 0.0f, 255.0f, 1.0f, blueTitle, new Tuple<Runnable, Object, Runnable>(() -> {
            ColorSection sect = this.getInstance().getEnd();
            sect.blue = (int)this.endBlue.getSliderValue();
            this.setEndColor(sect);
        }, null, () -> {
            ColorSection sect = this.getInstance().getEnd();
            sect.blue = (int)this.endBlue.getSliderValue();
            this.setEndColor(sect);
        })));
        this.endAlpha = this.childFrame.addControl(new SliderControl(new Pair<Integer, Integer>(calc1, this.getButtonY(11)), new Pair<Integer, Integer>(180, 20), (float)this.getInstance().getEnd().alpha, 0.0f, 255.0f, 1.0f, alphaTitle, new Tuple<Runnable, Object, Runnable>(() -> {
            ColorSection sect = this.getInstance().getEnd();
            sect.alpha = (int)this.endAlpha.getSliderValue();
            this.setEndColor(sect);
        }, null, () -> {
            ColorSection sect = this.getInstance().getEnd();
            sect.alpha = (int)this.endAlpha.getSliderValue();
            this.setEndColor(sect);
        })));
        this.childFrame.addWidget(new TexturedWidget(this.childFrame, calc2, this.getButtonY(8, 1), calcAlt, 93, 0.0, () -> Float.valueOf(1.0f), () -> this.storedEnd, true));
        this.childFrame.addWidget(new TextDisplayWidget((ExtendedScreen)this.childFrame, calc1, this.getButtonY(12), this.getScreenWidth(), previewTitle));
        this.textureLocationText = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(13), 180, 20, () -> this.getInstance().setTexLocation(this.textureLocationText.getControlMessage()), "gui.config.message.editor.texture_path"));
        this.textureLocationText.setControlMessage(this.getInstance().getTexLocation());
        this.tintFactor = this.childFrame.addControl(new SliderControl(new Pair<Integer, Integer>(calc1, this.getButtonY(14)), new Pair<Integer, Integer>(180, 20), 100.0f, 0.0f, 100.0f, 1.0f, tintFactorTitle));
        this.childFrame.addWidget(new TexturedWidget(this.childFrame, calc2, this.getButtonY(14, 1), calcAlt, 93, 0.0, () -> Float.valueOf(this.tintFactor.getSliderValue(true)), this::getInstance, true));
    }

    @Override
    protected boolean canReset() {
        return !this.getCurrentData().equals(this.DEFAULTS);
    }

    @Override
    protected boolean allowedToReset() {
        return true;
    }

    @Override
    protected boolean resetData() {
        return this.setCurrentData(this.DEFAULTS);
    }

    @Override
    protected boolean canSync() {
        return true;
    }

    @Override
    protected boolean allowedToSync() {
        return true;
    }

    @Override
    protected boolean syncData() {
        return this.setCurrentData(this.syncSupplier.get());
    }

    @Override
    protected void applySettings() {
        this.setCurrentData(this.getInstance());
    }

    @Override
    protected ColorData getOriginalData() {
        return this.DEFAULTS;
    }

    @Override
    protected ColorData getCurrentData() {
        return this.CURRENT;
    }

    @Override
    protected boolean setCurrentData(ColorData data) {
        if (data.getStart() != null && data.getStart().equals(data.getEnd())) {
            data.setEndColor(null);
        }
        if (StringUtils.isNullOrEmpty(data.getTexLocation())) {
            data.setTexLocation(null);
        }
        if (!this.getCurrentData().equals(data)) {
            this.getCurrentData().transferFrom(data);
            CraftPresence.CONFIG.hasChanged = true;
            return true;
        }
        return false;
    }

    protected ColorData getInstance() {
        return this.INSTANCE;
    }

    private void setStartColor(ColorSection sect) {
        this.getInstance().setStartColor(sect);
        this.storedStart.setStartColor(sect);
    }

    private void setEndColor(ColorSection sect) {
        this.getInstance().setEndColor(sect);
        this.storedEnd.setStartColor(sect);
    }
}

